

use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\assets_mve_merge_ts.dta", replace
gen mve_assets_ratio = mve/atq

cd "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\"

gen name = "" 

replace name = "baml" if permno == 59408
replace name ="citi" if permno == 70519
replace name = "gs" if permno == 86868
replace name = "jpm" if permno == 47896
replace name = "ms" if permno == 69032
replace name = "wf" if permno == 38703


gen date_use = date(date, "MDY")
br date_use 

egen id = group(name)
tsset id date_use 

drop if mve_assets_ratio <= 0 

tssmooth ma ratio_ma = mve_assets_ratio, window(90)

drop if ratio_ma <= 0 

label var ratio_ma "MVE/Total Assets"

format date_use %tdCCYY

gen recession =  . 
replace recession = 1 if (year == 2008 | year == 2009)
egen ratio_ma_max = max(ratio_ma) if name == "baml"

egen ratio_ma_max_baml = max(ratio_ma) if (name == "baml" & year > 1999)
label var ratio_ma_max_baml "" 

egen ratio_ma_max_citi = max(ratio_ma) if (name == "citi" & year > 1999)
label var ratio_ma_max_citi ""

egen ratio_ma_max_gs = max(ratio_ma) if (name == "gs" & year > 1999)
label var ratio_ma_max_gs ""

egen ratio_ma_max_jpm = max(ratio_ma) if (name == "jpm" & year > 1999)
label var ratio_ma_max_jpm "" 

egen ratio_ma_max_wf = max(ratio_ma) if (name == "wf" & year > 1999)
label var ratio_ma_max_wf "" 


egen ratio_ma_max_ms = max(ratio_ma) if (name == "ms" & year > 1999)
label var ratio_ma_max_ms "" 

cd "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Figures_EPS"

twoway (bar ratio_ma_max date_use if (recession == 1 & year >1999 & name == "baml"), color(gs12)) (line ratio_ma date_use)  if (name == "baml")

graph twoway (bar ratio_ma_max_baml date_use if (recession == 1 & year >1999 & name == "baml"), color(gs12) leg(off)) (line ratio_ma date_use if (name == "baml" & year> 1999)), xtitle("") title("MVE/A for Bank of America Over Time") xlabel(,labsize(small)) leg(off) 

graph export baml_ratio.eps, as(eps) replace 

graph twoway (bar ratio_ma_max_citi date_use if (recession == 1 & year >1999 & name == "citi"), color(gs12) leg(off)) (line ratio_ma date_use if (name == "citi" & year> 1999)), xtitle("") title("MVE/A for Citigroup Over Time") xlabel(,labsize(small)) leg(off)

graph export citi_ratio.eps, as(eps) replace 

graph twoway (bar ratio_ma_max_ms date_use if (recession == 1 & year >1999 & name == "ms"), color(gs12) leg(off)) (line ratio_ma date_use if (name == "ms" & year> 1999)), xtitle("") title("MVE/A for Morgan Stanley Over Time") xlabel(,labsize(small)) leg(off)

graph export ms_ratio.eps, as(eps) replace 

graph twoway (bar ratio_ma_max_gs date_use if (recession == 1 & year >1999 & name == "gs"), color(gs12) leg(off)) (line ratio_ma date_use if (name == "gs" & year> 1999)), xtitle("") title("MVE/A for Goldman Sachs Over Time") xlabel(,labsize(small)) leg(off)

graph export gs_ratio.eps, as(eps)replace 

graph twoway (bar ratio_ma_max_wf date_use if (recession == 1 & year >1999 & name == "wf"), color(gs12) leg(off)) (line ratio_ma date_use if (name == "wf" & year> 1999)), xtitle("") title("MVE/A for Wells Fargo Over Time") xlabel(,labsize(small)) leg(off)

graph export wf_ratio.eps, as(eps) replace 

graph twoway (bar ratio_ma_max_jpm date_use if (recession == 1 & year >1999 & name == "jpm"), color(gs12) leg(off)) (line ratio_ma date_use if (name == "jpm" & year> 1999)), xtitle("") title("MVE/A for JP Morgan Over Time") xlabel(,labsize(small)) leg(off)

graph export jpm_ratio.eps, as(eps) replace 
